import os, json, functools, operator
import random as rn
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd


nBins = 500
# basePath = "Y:\\1801_DLS_Harry\\paganin\\"
# outPath = "C:\\Local\\thesis\\Figures\\Chapter 5\\5_1"
basePath = "scanMeasurements\\"
outPath = "Appendix_B_figures"

None1 = {"99086", "99037"}
None2 = {"99087", "99072"}
None3 = {"99128", "99090"}
AOMDSS1 = {"99094", "99097", "99051", "99056", "99082", "99115"}
NoneAll = set().union(None1, None2, None3)
datasets = set().union(None1, None2, None3, AOMDSS1)

idx = np.zeros(40)
sliceVolumes = np.ones(nBins)
minVol, maxVol = 0, 3500000
minThick, maxThick = 10, 700
profLocs = []
volBins = np.linspace(minVol, maxVol, nBins)
thickBins = np.linspace(minThick, maxThick, nBins)
saveFigs = False
# saveFigs = True

dfSliceAreas = pd.DataFrame()
dfSliceThickness = pd.DataFrame()
for d in datasets:
	volumesPath = os.path.join(basePath, d+"_paganin_16bit")
	files = [f for f in os.listdir(volumesPath) if os.path.isfile(os.path.join(volumesPath, f))]
	for filename in files:
		with open(os.path.join(basePath, d+"_paganin_16bit", filename), 'r') as f:
			if filename.split("_")[1]=="in0-out2" and filename.split("_")[-1]=="volumes.txt":
				mucosalVolumesDict = json.load(f)
				mucosalVolumesDict["sliceVolumes"] = np.array(mucosalVolumesDict["sliceVolumes"])/float(mucosalVolumesDict["pixelSize"])
				dftmpSliceAreas = pd.DataFrame()
				dftmpSliceAreas['sliceAreas'] = np.array(mucosalVolumesDict["sliceVolumes"])/float(mucosalVolumesDict["pixelSize"])
				dftmpSliceAreas['scanId'] = d
				dftmpSliceAreas['treatmentGroup'] = 'AOM/DSS' if d in AOMDSS1 else 'None' if d in NoneAll else None
				dfSliceAreas = dfSliceAreas.append(dftmpSliceAreas, ignore_index=True)

			elif filename.split("_")[1]=="in0-out2" and filename.split("_")[-1]=="thickness.txt":
				mucosalThicknessDict = json.load(f)
				# if d in AOMDSS1 or d in NoneAll:
				# 	randMucosalThickness = rn.sample([rn.choice(mucosalThicknessDict["localThicknesses"][k]) for k in sorted(mucosalThicknessDict["localThicknesses"].keys())], 5)
				# 	print "Mean random mucosal thickness: ", np.mean(randMucosalThickness)
				mucosalThicknessDict["localThicknesses"] = [np.mean(mucosalThicknessDict["localThicknesses"][k]) for k in sorted(mucosalThicknessDict["localThicknesses"].keys())]
			elif filename.split("_")[1]=="in0-out1" and filename.split("_")[-1]=="volumes.txt":
				wallVolumesDict = json.load(f)
				wallVolumesDict["sliceVolumes"] = np.array(wallVolumesDict["sliceVolumes"])/float(wallVolumesDict["pixelSize"])
			elif filename.split("_")[1]=="in0-out1" and filename.split("_")[-1]=="thickness.txt":
				wallThicknessDict = json.load(f)
				wallThicknessDict["localThicknesses"] = [np.mean(wallThicknessDict["localThicknesses"][k]) for k in sorted(wallThicknessDict["localThicknesses"].keys())]
			elif filename.split("_")[1]=="in2-out1" and filename.split("_")[-1]=="volumes.txt":
				serosalVolumesDict = json.load(f)
				serosalVolumesDict["sliceVolumes"] = np.array(serosalVolumesDict["sliceVolumes"])/float(serosalVolumesDict["pixelSize"])
			elif filename.split("_")[1]=="in2-out1" and filename.split("_")[-1]=="thickness.txt":
				serosalThicknessDict = json.load(f)
				# print serosalThicknessDict["scanStackPath"]
				# if d in AOMDSS1 or d in NoneAll:
				# 	randSerosalThickness = rn.sample([rn.choice(serosalThicknessDict["localThicknesses"][k]) for k in sorted(serosalThicknessDict["localThicknesses"].keys())], 5)
				# 	print "Mean random serosal thickness: ", np.mean(randSerosalThickness)
				serosalThicknessDict["localThicknesses"] = [np.mean(serosalThicknessDict["localThicknesses"][k]) for k in sorted(serosalThicknessDict["localThicknesses"].keys())]


	if d in AOMDSS1:
		figID = 1
		fig = plt.figure(figID)
		idx[figID] += 1
		ax1 = fig.add_subplot(len(AOMDSS1)*100+10+idx[figID])
		plt.hist(wallVolumesDict["sliceVolumes"], volBins)
		plt.hist(serosalVolumesDict["sliceVolumes"], volBins)
		ax1.annotate(str(d), xy=(0.9,0.7), xycoords='axes fraction', fontsize=10)
		locs, labels = plt.xticks()
		plt.xticks([])

		figID = 11
		fig = plt.figure(figID)
		idx[figID] += 1
		ax11 = fig.add_subplot(len(AOMDSS1)*100+10+idx[figID])
		data = wallThicknessDict["localThicknesses"]
		plt.hist(data, thickBins)
		plt.hist(serosalThicknessDict["localThicknesses"], thickBins)
		plt.hist(mucosalThicknessDict["localThicknesses"], thickBins)
		# print "mean AOMDSS1 serosalThickness", np.mean(serosalThicknessDict["localThicknesses"])
		# print "mean AOMDSS1 mucosalThickness", np.mean(mucosalThicknessDict["localThicknesses"])
		# median, q1, q3 = np.percentile(data, 50), np.percentile(data, 25), np.percentile(data, 75)
		# print d, "Q", (q3-q1)
		ax11.annotate(str(d), xy=(0.9,0.7), xycoords='axes fraction', fontsize=10)
		# ax.annotate('m', xy=(median, 0), fontsize=10)
		# ax.annotate('q1', xy=(q1, 0), fontsize=10)
		# ax.annotate('q3', xy=(q3, 0), fontsize=10)
		thickLocs, _ = plt.xticks()
		plt.xticks([])

	elif d in NoneAll:
		figID = 4
		fig = plt.figure(figID)
		idx[figID] += 1
		ax4 = fig.add_subplot(len(NoneAll)*100+10+idx[figID])
		plt.hist(wallVolumesDict["sliceVolumes"], volBins)
		plt.hist(serosalVolumesDict["sliceVolumes"], volBins)
		ax4.annotate(str(d), xy=(0.9,0.7), xycoords='axes fraction', fontsize=10)
		locs, labels = plt.xticks()
		plt.xticks([])

		figID = 14
		fig = plt.figure(figID)
		idx[figID] += 1
		ax14 = fig.add_subplot(len(NoneAll)*100+10+idx[figID])
		data = wallThicknessDict["localThicknesses"]
		plt.hist(data, thickBins)
		plt.hist(serosalThicknessDict["localThicknesses"], thickBins)
		plt.hist(mucosalThicknessDict["localThicknesses"], thickBins)
		median, q1, q3 = np.percentile(data, 50), np.percentile(data, 25), np.percentile(data, 75)
		# print "mean None serosalThickness", np.mean(serosalThicknessDict["localThicknesses"])
		# print "mean None mucosalThickness", np.mean(mucosalThicknessDict["localThicknesses"])
		# print d, "Q", (q3-q1)
		ax14.annotate(str(d), xy=(0.9,0.7), xycoords='axes fraction', fontsize=10)
		# ax.annotate('m', xy=(median, 0), fontsize=10)
		# ax.annotate('q1', xy=(q1, 0), fontsize=10)
		# ax.annotate('q3', xy=(q3, 0), fontsize=10)
		thickLocs, _ = plt.xticks()
		plt.xticks([])

figID = 1
fig = plt.figure(figID)
plt.legend(labels=["Mucosa", "Serosa"], loc='upper left')
plt.suptitle("Area distribution: 1st cycle AOM & DSS - treated mice")
plt.subplot(len(AOMDSS1)*100+10+idx[figID])
plt.xticks(locs, np.linspace(minVol/1000.0, maxVol/1000.00, len(locs), dtype=np.int16))
plt.xlabel("Slice area [10^-3 * "+wallVolumesDict["pixelUnits:"]+"^2]")
fig.text(0.04, 0.5, 'Number of slices', va='center', rotation='vertical')
# fig.legend(handles=[None, None], labels=["Mucosa", "Serosa"], loc='upper left')
if saveFigs:
	plt.savefig(outPath+'Area distribution _ 1st cycle AOM & DSS - treated mice.png')

figID = 11
fig = plt.figure(figID)
plt.suptitle("Thickness distribution: 1st cycle AOM & DSS - treated mice")
plt.subplot(len(AOMDSS1)*100+10+idx[figID])
plt.xticks(thickLocs, np.linspace(minThick, maxThick, len(thickLocs), dtype=np.int16))
plt.xlabel("Mean thickness ["+wallThicknessDict["pixelUnits:"]+"]")
fig.text(0.04, 0.5, 'Number of slices', va='center', rotation='vertical')
if saveFigs:
	plt.savefig(outPath+'Thickness distribution _ 1st cycle AOM & DSS - treated mice.png')

figID = 4
fig = plt.figure(figID)
plt.suptitle("Area distribution: non - treated control mice")
plt.subplot(len(NoneAll)*100+10+idx[figID])
plt.xticks(locs, np.linspace(minVol/1000.0, maxVol/1000.00, len(locs), dtype=np.int16))
plt.xlabel("Slice area [10^-3 * "+wallVolumesDict["pixelUnits:"]+"^2]")
fig.text(0.04, 0.5, 'Number of slices', va='center', rotation='vertical')
if saveFigs:
	plt.savefig(outPath+'Area distribution _ non - treated control mice.png')

figID = 14
fig = plt.figure(figID)
plt.suptitle("Thickness distribution: non - treated control mice")
plt.subplot(len(NoneAll)*100+10+idx[figID])
plt.xticks(thickLocs, np.linspace(minThick, maxThick, len(thickLocs), dtype=np.int16))
plt.xlabel("Mean thickness ["+wallThicknessDict["pixelUnits:"]+"]")
fig.text(0.04, 0.5, 'Number of slices', va='center', rotation='vertical')
if saveFigs:
	plt.savefig(outPath+'Thickness distribution _ non - treated control mice.png')

#%%
plt.show()
#%%
dfSliceAreas
